/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.item.IEmpowerableItem;
import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.lib.util.OreDictionaryProxy;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class ItemHelper {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";
    public static OreDictionaryProxy oreProxy = new OreDictionaryProxy();

    private ItemHelper() {
    }

    public static ItemStack cloneStack(Item item, int n) {
        if (item == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(item, n);
        return itemStack;
    }

    public static ItemStack cloneStack(Block block, int n) {
        if (block == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(block, n);
        return itemStack;
    }

    public static ItemStack cloneStack(ItemStack itemStack, int n) {
        if (itemStack == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack.copy();
        itemStack2.stackSize = n;
        return itemStack2;
    }

    public static ItemStack cloneStack(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack.copy();
        return itemStack2;
    }

    public static ItemStack copyTag(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack2 != null && itemStack2.stackTagCompound != null) {
            itemStack.stackTagCompound = (NBTTagCompound)itemStack2.stackTagCompound.copy();
        }
        return itemStack;
    }

    public static NBTTagCompound setItemStackTagName(NBTTagCompound nBTTagCompound, String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        if (!nBTTagCompound.hasKey("display")) {
            nBTTagCompound.setTag("display", (NBTBase)new NBTTagCompound());
        }
        nBTTagCompound.getCompoundTag("display").setString("Name", string);
        return nBTTagCompound;
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack = new ItemStack(Item.getItemById((int)nBTTagCompound.getShort("id")));
        itemStack.stackSize = nBTTagCompound.getInteger("Count");
        itemStack.setItemDamage(Math.max(0, nBTTagCompound.getShort("Damage")));
        if (nBTTagCompound.hasKey("tag", 10)) {
            itemStack.stackTagCompound = nBTTagCompound.getCompoundTag("tag");
        }
        return itemStack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack itemStack, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("id", (short)Item.getIdFromItem((Item)itemStack.getItem()));
        nBTTagCompound.setInteger("Count", itemStack.stackSize);
        nBTTagCompound.setShort("Damage", (short)ItemHelper.getItemDamage(itemStack));
        if (itemStack.stackTagCompound != null) {
            nBTTagCompound.setTag("tag", (NBTBase)itemStack.stackTagCompound);
        }
        return nBTTagCompound;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack itemStack, int n, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("id", (short)Item.getIdFromItem((Item)itemStack.getItem()));
        nBTTagCompound.setInteger("Count", n);
        nBTTagCompound.setShort("Damage", (short)ItemHelper.getItemDamage(itemStack));
        if (itemStack.stackTagCompound != null) {
            nBTTagCompound.setTag("tag", (NBTBase)itemStack.stackTagCompound);
        }
        return nBTTagCompound;
    }

    public static String getNameFromItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.stackTagCompound == null || !itemStack.stackTagCompound.hasKey("display")) {
            return "";
        }
        return itemStack.stackTagCompound.getCompoundTag("display").getString("Name");
    }

    public static ItemStack damageItem(ItemStack itemStack, int n, Random random) {
        if (itemStack != null && itemStack.isItemStackDamageable() && itemStack.attemptDamageItem(n, random)) {
            if (--itemStack.stackSize <= 0) {
                itemStack = null;
            } else {
                itemStack.setItemDamage(0);
            }
        }
        return itemStack;
    }

    public static ItemStack consumeItem(ItemStack itemStack) {
        boolean bl;
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.getItem();
        boolean bl2 = bl = itemStack.stackSize > 1;
        if (bl) {
            --itemStack.stackSize;
        }
        if (item.hasContainerItem(itemStack)) {
            ItemStack itemStack2 = item.getContainerItem(itemStack);
            if (itemStack2 == null) {
                return null;
            }
            if (itemStack2.isItemStackDamageable() && itemStack2.getItemDamage() > itemStack2.getMaxDamage()) {
                itemStack2 = null;
            }
            return itemStack2;
        }
        return bl ? itemStack : null;
    }

    public static ItemStack consumeItem(ItemStack itemStack, EntityPlayer entityPlayer) {
        boolean bl;
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.getItem();
        boolean bl2 = bl = itemStack.stackSize > 1;
        if (bl) {
            --itemStack.stackSize;
        }
        if (item.hasContainerItem(itemStack)) {
            ItemStack itemStack2 = item.getContainerItem(itemStack);
            if (itemStack2 == null || itemStack2.isItemStackDamageable() && itemStack2.getItemDamage() > itemStack2.getMaxDamage()) {
                itemStack2 = null;
            }
            if (itemStack.stackSize < 1) {
                return itemStack2;
            }
            if (itemStack2 != null && !entityPlayer.inventory.addItemStackToInventory(itemStack2)) {
                entityPlayer.func_146097_a(itemStack2, false, true);
            }
        }
        return bl ? itemStack : null;
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl) {
        return ItemHelper.disposePlayerItem(itemStack, itemStack2, entityPlayer, bl, true);
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl, boolean bl2) {
        if (entityPlayer == null || entityPlayer.capabilities.isCreativeMode) {
            return true;
        }
        if (bl2 && itemStack.stackSize <= 1) {
            entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, null);
            entityPlayer.inventory.addItemStackToInventory(itemStack2);
            return true;
        }
        if (bl) {
            --itemStack.stackSize;
            if (itemStack2 != null && !entityPlayer.inventory.addItemStackToInventory(itemStack2)) {
                entityPlayer.func_146097_a(itemStack2, false, true);
            }
            return true;
        }
        return false;
    }

    public static int getItemDamage(ItemStack itemStack) {
        return Items.diamond.getDamage(itemStack);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inventoryCrafting, World world) {
        ItemStack[] itemStackArray = new ItemStack[2];
        for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
            if (inventoryCrafting.getStackInSlot(i) == null) continue;
            if (itemStackArray[0] == null) {
                itemStackArray[0] = inventoryCrafting.getStackInSlot(i);
                continue;
            }
            itemStackArray[1] = inventoryCrafting.getStackInSlot(i);
            break;
        }
        if (itemStackArray[0] == null || itemStackArray[0].getItem() == null) {
            return null;
        }
        if (itemStackArray[1] != null && itemStackArray[0].getItem() == itemStackArray[1].getItem() && itemStackArray[0].stackSize == 1 && itemStackArray[1].stackSize == 1 && itemStackArray[0].getItem().isRepairable()) {
            Item item = itemStackArray[0].getItem();
            int n = item.getMaxDamage() - itemStackArray[0].getItemDamageForDisplay();
            int n2 = item.getMaxDamage() - itemStackArray[1].getItemDamageForDisplay();
            int n3 = n + n2 + item.getMaxDamage() * 5 / 100;
            int n4 = Math.max(0, item.getMaxDamage() - n3);
            return new ItemStack(itemStackArray[0].getItem(), 1, n4);
        }
        for (int i = 0; i < CraftingManager.getInstance().getRecipeList().size(); ++i) {
            IRecipe iRecipe = (IRecipe)CraftingManager.getInstance().getRecipeList().get(i);
            if (!iRecipe.matches(inventoryCrafting, world)) continue;
            return iRecipe.getCraftingResult(inventoryCrafting);
        }
        return null;
    }

    public static ItemStack getOre(String string) {
        return oreProxy.getOre(string);
    }

    public static String getOreName(ItemStack itemStack) {
        return oreProxy.getOreName(itemStack);
    }

    public static boolean isOreIDEqual(ItemStack itemStack, int n) {
        return oreProxy.isOreIDEqual(itemStack, n);
    }

    public static boolean isOreNameEqual(ItemStack itemStack, String string) {
        return oreProxy.isOreNameEqual(itemStack, string);
    }

    public static boolean oreNameExists(String string) {
        return oreProxy.oreNameExists(string);
    }

    public static boolean hasOreName(ItemStack itemStack) {
        return !ItemHelper.getOreName(itemStack).equals("Unknown");
    }

    public static boolean isBlock(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(ORE);
    }

    public static boolean isDust(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(INGOT);
    }

    public static boolean isNugget(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(LOG);
    }

    public static final ItemStack stack(Item item) {
        return new ItemStack(item);
    }

    public static final ItemStack stack(Item item, int n) {
        return new ItemStack(item, n);
    }

    public static final ItemStack stack(Item item, int n, int n2) {
        return new ItemStack(item, n, n2);
    }

    public static final ItemStack stack(Block block) {
        return new ItemStack(block);
    }

    public static final ItemStack stack(Block block, int n) {
        return new ItemStack(block, n);
    }

    public static final ItemStack stack(Block block, int n, int n2) {
        return new ItemStack(block, n, n2);
    }

    public static final ItemStack stack2(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Item item, int n) {
        return new ItemStack(item, n, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Block block) {
        return new ItemStack(block, 1, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Block block, int n) {
        return new ItemStack(block, n, Short.MAX_VALUE);
    }

    public static final IRecipe ShapedRecipe(Block block, Object ... objectArray) {
        return new ShapedOreRecipe(block, objectArray);
    }

    public static final IRecipe ShapedRecipe(Item item, Object ... objectArray) {
        return new ShapedOreRecipe(item, objectArray);
    }

    public static final IRecipe ShapedRecipe(ItemStack itemStack, Object ... objectArray) {
        return new ShapedOreRecipe(itemStack, objectArray);
    }

    public static final IRecipe ShapedRecipe(Block block, int n, Object ... objectArray) {
        return new ShapedOreRecipe(ItemHelper.stack(block, n), objectArray);
    }

    public static final IRecipe ShapedRecipe(Item item, int n, Object ... objectArray) {
        return new ShapedOreRecipe(ItemHelper.stack(item, n), objectArray);
    }

    public static final IRecipe ShapedRecipe(ItemStack itemStack, int n, Object ... objectArray) {
        return new ShapedOreRecipe(ItemHelper.cloneStack(itemStack, n), objectArray);
    }

    public static final IRecipe ShapelessRecipe(Block block, Object ... objectArray) {
        return new ShapelessOreRecipe(block, objectArray);
    }

    public static final IRecipe ShapelessRecipe(Item item, Object ... objectArray) {
        return new ShapelessOreRecipe(item, objectArray);
    }

    public static final IRecipe ShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        return new ShapelessOreRecipe(itemStack, objectArray);
    }

    public static final IRecipe ShapelessRecipe(Block block, int n, Object ... objectArray) {
        return new ShapelessOreRecipe(ItemHelper.stack(block, n), objectArray);
    }

    public static final IRecipe ShapelessRecipe(Item item, int n, Object ... objectArray) {
        return new ShapelessOreRecipe(ItemHelper.stack(item, n), objectArray);
    }

    public static final IRecipe ShapelessRecipe(ItemStack itemStack, int n, Object ... objectArray) {
        return new ShapelessOreRecipe(ItemHelper.cloneStack(itemStack, n), objectArray);
    }

    public static boolean addGearRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, " X ", "XIX", " X ", Character.valueOf('X'), string, Character.valueOf('I'), "ingotIron"));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, String string, String string2) {
        if (itemStack == null || !ItemHelper.oreNameExists(string) || !ItemHelper.oreNameExists(string2)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, " X ", "XIX", " X ", Character.valueOf('X'), string, Character.valueOf('I'), string2));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, String string, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, " X ", "XIX", " X ", Character.valueOf('X'), string, Character.valueOf('I'), itemStack2));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, ItemStack itemStack2, String string) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, " X ", "XIX", " X ", Character.valueOf('X'), itemStack2, Character.valueOf('I'), string));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        if (itemStack == null | itemStack2 == null | itemStack3 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1), Character.valueOf('I'), ItemHelper.cloneStack(itemStack3, 1)});
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, String string, String string2) {
        if (itemStack == null || !ItemHelper.oreNameExists(string) || !ItemHelper.oreNameExists(string2)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "X X", " I ", "X X", Character.valueOf('X'), string, Character.valueOf('I'), string2));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, String string, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "X X", " I ", "X X", Character.valueOf('X'), string, Character.valueOf('I'), itemStack2));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, ItemStack itemStack2, String string) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "X X", " I ", "X X", Character.valueOf('X'), itemStack2, Character.valueOf('I'), string));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        if (itemStack == null | itemStack2 == null | itemStack3 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1), Character.valueOf('I'), ItemHelper.cloneStack(itemStack3, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        if (itemStack == null | itemStack2 == null | itemStack3 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(itemStack3, 1), Character.valueOf('I'), ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, String string, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "XXX", "XIX", "XXX", Character.valueOf('X'), itemStack2, Character.valueOf('I'), string));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, ItemStack itemStack2, String string) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "XXX", "XIX", "XXX", Character.valueOf('X'), string, Character.valueOf('I'), itemStack2));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, String string, String string2) {
        if (itemStack == null || !ItemHelper.oreNameExists(string) || !ItemHelper.oreNameExists(string2)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "XXX", "XIX", "XXX", Character.valueOf('X'), string2, Character.valueOf('I'), string));
        return true;
    }

    public static boolean addFenceRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addFenceRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "XXX", "XXX", Character.valueOf('X'), string));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(ItemHelper.cloneStack(itemStack, 9), string));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack, 9), (Object[])new Object[]{ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(ItemHelper.cloneStack(itemStack, 4), string));
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack, 4), (Object[])new Object[]{ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(itemStack, string, string, string, string, string, string, string, string, string));
        return true;
    }

    public static boolean addStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        itemStack2 = ItemHelper.cloneStack(itemStack2, 1);
        GameRegistry.addShapelessRecipe((ItemStack)itemStack, (Object[])new Object[]{itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2});
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, "XX", "XX", Character.valueOf('X'), string));
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addTwoWayStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.addStorageRecipe(itemStack, itemStack2) && ItemHelper.addReverseStorageRecipe(itemStack2, itemStack);
    }

    public static boolean addTwoWayStorageRecipe(ItemStack itemStack, String string, ItemStack itemStack2, String string2) {
        return ItemHelper.addStorageRecipe(itemStack, string2) && ItemHelper.addReverseStorageRecipe(itemStack2, string);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.addSmallStorageRecipe(itemStack, itemStack2) && ItemHelper.addSmallReverseStorageRecipe(itemStack2, itemStack);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack itemStack, String string, ItemStack itemStack2, String string2) {
        return ItemHelper.addSmallStorageRecipe(itemStack, string2) && ItemHelper.addSmallReverseStorageRecipe(itemStack2, string);
    }

    public static boolean addSmelting(ItemStack itemStack, Item item) {
        if (itemStack == null | item == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(item, 1), ItemHelper.cloneStack(itemStack), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, Block block) {
        if (itemStack == null | block == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(block, 1), ItemHelper.cloneStack(itemStack), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(itemStack2, 1), ItemHelper.cloneStack(itemStack), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, Item item, float f) {
        if (itemStack == null | item == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(item, 1), ItemHelper.cloneStack(itemStack), f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, Block block, float f) {
        if (itemStack == null | block == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(block, 1), ItemHelper.cloneStack(itemStack), f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, ItemStack itemStack2, float f) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(itemStack2, 1), ItemHelper.cloneStack(itemStack), f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack itemStack, Item item) {
        if (itemStack == null | item == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(item, 1), ItemHelper.cloneStack(itemStack), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack itemStack, Block block) {
        if (itemStack == null | block == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(block, 1), ItemHelper.cloneStack(itemStack), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(ItemHelper.cloneStack(itemStack2, 1), ItemHelper.cloneStack(itemStack), 0.1f);
        return true;
    }

    public static boolean addTwoWayConversionRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack, 1), (Object[])new Object[]{ItemHelper.cloneStack(itemStack2, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack2, 1), (Object[])new Object[]{ItemHelper.cloneStack(itemStack, 1)});
        return true;
    }

    public static void registerWithHandlers(String string, ItemStack itemStack) {
        OreDictionary.registerOre((String)string, (ItemStack)itemStack);
        GameRegistry.registerCustomItemStack((String)string, (ItemStack)itemStack);
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)itemStack);
    }

    public static void addRecipe(IRecipe iRecipe) {
        GameRegistry.addRecipe((IRecipe)iRecipe);
    }

    public static void addRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((ItemStack)itemStack, (Object[])objectArray);
    }

    public static void addShapedRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((ItemStack)itemStack, (Object[])objectArray);
    }

    public static void addShapedRecipe(Item item, Object ... objectArray) {
        ItemHelper.addRecipe(new ItemStack(item), objectArray);
    }

    public static void addShapedRecipe(Block block, Object ... objectArray) {
        ItemHelper.addRecipe(new ItemStack(block), objectArray);
    }

    public static void addShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addShapelessRecipe((ItemStack)itemStack, (Object[])objectArray);
    }

    public static void addShapelessRecipe(Item item, Object ... objectArray) {
        ItemHelper.addShapelessRecipe(new ItemStack(item), objectArray);
    }

    public static void addShapelessRecipe(Block block, Object ... objectArray) {
        ItemHelper.addShapelessRecipe(new ItemStack(block), objectArray);
    }

    public static void addShapedOreRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, objectArray));
    }

    public static void addShapedOreRecipe(Item item, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(item, objectArray));
    }

    public static void addShapedOreRecipe(Block block, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(block, objectArray));
    }

    public static void addShapelessOreRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(itemStack, objectArray));
    }

    public static void addShapelessOreRecipe(Item item, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(item, objectArray));
    }

    public static void addShapelessOreRecipe(Block block, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(block, objectArray));
    }

    public static boolean isPlayerHoldingEmpowerableItem(EntityPlayer entityPlayer) {
        Item item = entityPlayer.getCurrentEquippedItem() != null ? entityPlayer.getCurrentEquippedItem().getItem() : null;
        return item instanceof IEmpowerableItem;
    }

    public static boolean isPlayerHoldingEmpoweredItem(EntityPlayer entityPlayer) {
        Item item = entityPlayer.getCurrentEquippedItem() != null ? entityPlayer.getCurrentEquippedItem().getItem() : null;
        return item instanceof IEmpowerableItem && ((IEmpowerableItem)item).isEmpowered(entityPlayer.getCurrentEquippedItem());
    }

    public static boolean toggleHeldEmpowerableItemState(EntityPlayer entityPlayer) {
        ItemStack itemStack;
        IEmpowerableItem iEmpowerableItem;
        return iEmpowerableItem.setEmpoweredState(itemStack, !(iEmpowerableItem = (IEmpowerableItem)(itemStack = entityPlayer.getCurrentEquippedItem()).getItem()).isEmpowered(itemStack));
    }

    public static boolean isPlayerHoldingMultiModeItem(EntityPlayer entityPlayer) {
        Item item = entityPlayer.getCurrentEquippedItem() != null ? entityPlayer.getCurrentEquippedItem().getItem() : null;
        return item instanceof IMultiModeItem;
    }

    public static boolean incrHeldMultiModeItemState(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.getCurrentEquippedItem();
        IMultiModeItem iMultiModeItem = (IMultiModeItem)itemStack.getItem();
        return iMultiModeItem.incrMode(itemStack);
    }

    public static boolean decrHeldMultiModeItemState(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.getCurrentEquippedItem();
        IMultiModeItem iMultiModeItem = (IMultiModeItem)itemStack.getItem();
        return iMultiModeItem.incrMode(itemStack);
    }

    public static boolean setHeldMultiModeItemState(EntityPlayer entityPlayer, int n) {
        ItemStack itemStack = entityPlayer.getCurrentEquippedItem();
        IMultiModeItem iMultiModeItem = (IMultiModeItem)itemStack.getItem();
        return iMultiModeItem.setMode(itemStack, n);
    }

    public static final boolean isPlayerHoldingFluidContainer(EntityPlayer entityPlayer) {
        return FluidContainerRegistry.isContainer((ItemStack)entityPlayer.getCurrentEquippedItem());
    }

    public static final boolean isPlayerHoldingFluidContainerItem(EntityPlayer entityPlayer) {
        return FluidHelper.isPlayerHoldingFluidContainerItem(entityPlayer);
    }

    public static final boolean isPlayerHoldingEnergyContainerItem(EntityPlayer entityPlayer) {
        return EnergyHelper.isPlayerHoldingEnergyContainerItem(entityPlayer);
    }

    public static final boolean isPlayerHoldingNothing(EntityPlayer entityPlayer) {
        return entityPlayer.getCurrentEquippedItem() == null;
    }

    public static Item getItemFromStack(ItemStack itemStack) {
        return itemStack == null ? null : itemStack.getItem();
    }

    public static boolean areItemsEqual(Item item, Item item2) {
        if (item == null | item2 == null) {
            return false;
        }
        return item == item2 || item.equals(item2);
    }

    public static final boolean isPlayerHoldingItem(Class<?> clazz, EntityPlayer entityPlayer) {
        return clazz.isInstance(ItemHelper.getItemFromStack(entityPlayer.getCurrentEquippedItem()));
    }

    public static final boolean isPlayerHoldingItem(Item item, EntityPlayer entityPlayer) {
        return ItemHelper.areItemsEqual(item, ItemHelper.getItemFromStack(entityPlayer.getCurrentEquippedItem()));
    }

    public static final boolean isPlayerHoldingItemStack(ItemStack itemStack, EntityPlayer entityPlayer) {
        return ItemHelper.itemsEqualWithMetadata(itemStack, entityPlayer.getCurrentEquippedItem());
    }

    public static boolean itemsDamageEqual(ItemStack itemStack, ItemStack itemStack2) {
        return !itemStack.getHasSubtypes() && itemStack.getMaxDamage() == 0 || ItemHelper.getItemDamage(itemStack) == ItemHelper.getItemDamage(itemStack2);
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        return ItemHelper.areItemsEqual(itemStack.getItem(), itemStack2.getItem());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && (!bl || ItemHelper.doNBTsMatch(itemStack.stackTagCompound, itemStack2.stackTagCompound));
    }

    public static boolean itemsEqualWithMetadata(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && ItemHelper.itemsDamageEqual(itemStack, itemStack2);
    }

    public static boolean itemsEqualWithMetadata(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return ItemHelper.itemsEqualWithMetadata(itemStack, itemStack2) && (!bl || ItemHelper.doNBTsMatch(itemStack.stackTagCompound, itemStack2.stackTagCompound));
    }

    public static boolean itemsIdentical(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && ItemHelper.getItemDamage(itemStack) == ItemHelper.getItemDamage(itemStack2) && ItemHelper.doNBTsMatch(itemStack.stackTagCompound, itemStack2.stackTagCompound);
    }

    public static boolean doNBTsMatch(NBTTagCompound nBTTagCompound, NBTTagCompound nBTTagCompound2) {
        if (nBTTagCompound == null & nBTTagCompound2 == null) {
            return true;
        }
        if (nBTTagCompound != null & nBTTagCompound2 != null) {
            return nBTTagCompound.equals((Object)nBTTagCompound2);
        }
        return false;
    }

    public static boolean itemsEqualForCrafting(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && (!itemStack.getHasSubtypes() || ItemHelper.getItemDamage(itemStack) == Short.MAX_VALUE || ItemHelper.getItemDamage(itemStack2) == Short.MAX_VALUE || ItemHelper.getItemDamage(itemStack2) == ItemHelper.getItemDamage(itemStack));
    }

    public static boolean craftingEquivalent(ItemStack itemStack, ItemStack itemStack2, String string, ItemStack itemStack3) {
        if (ItemHelper.itemsEqualForCrafting(itemStack, itemStack2)) {
            return true;
        }
        if (itemStack3 != null && ItemHelper.isBlacklist(itemStack3)) {
            return false;
        }
        if (string == null || string.equals("Unknown")) {
            return false;
        }
        return ItemHelper.getOreName(itemStack).equalsIgnoreCase(string);
    }

    public static boolean doOreIDsMatch(ItemStack itemStack, ItemStack itemStack2) {
        int n = oreProxy.getOreID(itemStack);
        return n >= 0 && n == oreProxy.getOreID(itemStack2);
    }

    public static boolean isBlacklist(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return Item.getItemFromBlock((Block)Blocks.birch_stairs) == item || Item.getItemFromBlock((Block)Blocks.jungle_stairs) == item || Item.getItemFromBlock((Block)Blocks.oak_stairs) == item || Item.getItemFromBlock((Block)Blocks.spruce_stairs) == item || Item.getItemFromBlock((Block)Blocks.planks) == item || Item.getItemFromBlock((Block)Blocks.wooden_slab) == item;
    }

    public static String getItemNBTString(ItemStack itemStack, String string, String string2) {
        return itemStack.stackTagCompound != null && itemStack.stackTagCompound.hasKey(string) ? itemStack.stackTagCompound.getString(string) : string2;
    }

    public static void addInventoryInformation(ItemStack itemStack, List<String> list) {
        ItemHelper.addInventoryInformation(itemStack, list, 0, Integer.MAX_VALUE);
    }

    public static void addInventoryInformation(ItemStack itemStack, List<String> list, int n, int n2) {
        int n3;
        if (itemStack.stackTagCompound == null) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        if (itemStack.getItem() instanceof IInventoryContainerItem && itemStack.stackTagCompound.hasKey("Accessible")) {
            ItemHelper.addAccessibleInventoryInformation(itemStack, list, n, n2);
            return;
        }
        if (!itemStack.stackTagCompound.hasKey("Inventory", 9) || itemStack.stackTagCompound.getTagList("Inventory", (int)itemStack.stackTagCompound.getId()).tagCount() <= 0) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        NBTTagList nBTTagList = itemStack.stackTagCompound.getTagList("Inventory", (int)itemStack.stackTagCompound.getId());
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        boolean[] blArray = new boolean[nBTTagList.tagCount()];
        for (int i = 0; i < nBTTagList.tagCount(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.getCompoundTagAt(i);
            n3 = nBTTagCompound.getInteger("Slot");
            if (blArray[i] || n3 < n || n3 > n2) continue;
            blArray[i] = true;
            ItemStack itemStack2 = ItemStack.loadItemStackFromNBT((NBTTagCompound)nBTTagCompound);
            if (itemStack2 == null) continue;
            arrayList.add(itemStack2);
            for (int j = 0; j < nBTTagList.tagCount(); ++j) {
                ItemStack itemStack3;
                NBTTagCompound nBTTagCompound2 = nBTTagList.getCompoundTagAt(j);
                int n4 = nBTTagCompound.getInteger("Slot");
                if (blArray[j] || n4 < n || n4 > n2 || (itemStack3 = ItemStack.loadItemStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null || !ItemHelper.itemsIdentical(itemStack2, itemStack3)) continue;
                itemStack2.stackSize += itemStack3.stackSize;
                blArray[j] = true;
            }
        }
        if (arrayList.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        }
        for (ItemStack itemStack2 : arrayList) {
            n3 = itemStack2.getMaxStackSize();
            if (!StringHelper.displayStackCount || itemStack2.stackSize < n3 || n3 == 1) {
                list.add("    \u00a7a" + itemStack2.stackSize + " " + StringHelper.getItemName(itemStack2));
                continue;
            }
            if (itemStack2.stackSize % n3 != 0) {
                list.add("    \u00a7a" + n3 + "x" + itemStack2.stackSize / n3 + "+" + itemStack2.stackSize % n3 + " " + StringHelper.getItemName(itemStack2));
                continue;
            }
            list.add("    \u00a7a" + n3 + "x" + itemStack2.stackSize / n3 + " " + StringHelper.getItemName(itemStack2));
        }
    }

    public static void addAccessibleInventoryInformation(ItemStack itemStack, List<String> list, int n, int n2) {
        int n3 = ((IInventoryContainerItem)itemStack.getItem()).getSizeInventory(itemStack);
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        boolean[] blArray = new boolean[n3];
        NBTTagCompound nBTTagCompound = itemStack.stackTagCompound;
        if (nBTTagCompound.hasKey("Inventory")) {
            nBTTagCompound = nBTTagCompound.getCompoundTag("Inventory");
        }
        for (int i = n; i < Math.min(n3, n2); ++i) {
            if (blArray[i] || !nBTTagCompound.hasKey("Slot" + i)) continue;
            ItemStack itemStack2 = ItemStack.loadItemStackFromNBT((NBTTagCompound)nBTTagCompound.getCompoundTag("Slot" + i));
            blArray[i] = true;
            if (itemStack2 == null) continue;
            arrayList.add(itemStack2);
            for (int j = n; j < Math.min(n3, n2); ++j) {
                ItemStack itemStack3;
                if (blArray[j] || !nBTTagCompound.hasKey("Slot" + j) || (itemStack3 = ItemStack.loadItemStackFromNBT((NBTTagCompound)nBTTagCompound.getCompoundTag("Slot" + j))) == null || !ItemHelper.itemsIdentical(itemStack2, itemStack3)) continue;
                itemStack2.stackSize += itemStack3.stackSize;
                blArray[j] = true;
            }
        }
        if (arrayList.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        } else {
            list.add(StringHelper.localize("info.cofh.empty"));
        }
        for (ItemStack itemStack4 : arrayList) {
            int n4 = itemStack4.getMaxStackSize();
            if (!StringHelper.displayStackCount || itemStack4.stackSize < n4 || n4 == 1) {
                list.add("    \u00a7a" + itemStack4.stackSize + " " + StringHelper.getItemName(itemStack4));
                continue;
            }
            if (itemStack4.stackSize % n4 != 0) {
                list.add("    \u00a7a" + n4 + "x" + itemStack4.stackSize / n4 + "+" + itemStack4.stackSize % n4 + " " + StringHelper.getItemName(itemStack4));
                continue;
            }
            list.add("    \u00a7a" + n4 + "x" + itemStack4.stackSize / n4 + " " + StringHelper.getItemName(itemStack4));
        }
    }
}

